***To create Figures 1 & 2

*This replication file is for Figures 1 and 2 in O'Dwyer and Stenberg (2021). The primary replication file for the analysis in this article is elsewhere in this zip file. Data for these two figures
*comes from V-DEM. The limited data we used for our analysis is here in two separate CSVs. Please adjust the file path for importing files as necessary for your machine.

set scheme s1mono

**Figure 1: Liberal democracy index
import delimited "~/Liberal Democracy Index.csv", encoding(ISO-8859-1)

**Without confidence intervals and WITHOUT Title Caption
twoway (line hungary year, lcolor(black) lpattern(dash)) (line poland year, lcolor(black) lpattern(solid)), ytitle("Liberal Democracy Index") xmtick(1990(2)2020) legend(order(1 2))
clear 
**Without confidence intervals and WITH Title Caption
*twoway (line hungary year, lcolor(black) lpattern(dash)) (line poland year, lcolor(black) lpattern(solid)), ytitle("Liberal Democracy Index") xmtick(1990(2)2020) title("Figure 1: National-Level Democratic Backsliding in", size(medlarge)) subtitle("Hungary and Poland Compared (1989-2020)", size(medlarge)) legend(order(1 2))


**Figure 2: Subnational political control 
import delimited "~/Subnational party control.csv", encoding(ISO-8859-1)
**Without confidence intervals and WITHOUT Title Caption
twoway (line hungary year, lcolor(black) lpattern(dash)) (line poland year, lcolor(black) lpattern(solid)), ytitle("Subnational Party Control Index") xmtick(1990(2)2020) legend(order(1 2))
clear
**Without confidence intervals and WITH Title Caption
*twoway (line hungary year, lcolor(black) lpattern(dash)) (line poland year, lcolor(black) lpattern(solid)), ytitle("Subnational Party Control Index") xmtick(1990(2)2020) title("Figure 2: National Party Influence at the Subnational Level in", size(medlarge)) subtitle("Hungary and Poland Compared (1989-2020)", size(medlarge)) legend(order(1 2))



***************NOTES ON GRAPHING
**Can get legends on two lines with this variation
*twoway (line hungary year, lcolor(black) lpattern(dash)) (line poland year, lcolor(black) lpattern(solid)), ytitle(V-Dem's "Liberal Democratic Index") xmtick(1990(2)2020) title("Figure 1: National-Level Democratic Backsliding in", size(medlarge)) subtitle("Hungary and Poland Compared (1989-2020)", size(medlarge)) legend(order(1 2))

**Can add confidence intervals with this command
*twoway (connected hungary year, mcolor(black) msize(medsmall) msymbol(triangle) lcolor(black)) (connected poland year, mcolor(black) msize(medsmall) msymbol(circle) lcolor(black) lpattern(solid)) (line hungarycilow year, lcolor(black) lpattern(tight_dot)) (line hungarycihigh year, lpattern(tight_dot)) (line polandcilow year, lcolor(black) lpattern(tight_dot)) (line polandcihigh year, lcolor(black) lpattern(tight_dot)), xmtick(1990(2)2020) title("Figure 2: National Party Influence at the Subnational Level in", size(medlarge) span) subtitle("Hungary and Poland Compared (1989-2020)", size(medlarge)) legend(order(1 2))

